package com.bcxin.fdd.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * description：百川信法大大签署任务表
 * author：linchunpeng
 * date：2024/7/11
 */
@Data
@TableName("bf_sign_task")
public class BfSignTaskEntity implements Serializable {

   private static final long serialVersionUID = 1L;

   //主键id
   @TableId(value = "id")
   private Long id;

   //任务类型，1劳动合同；2-其他合同
   private Integer taskType;

   //任务名称
   private String taskName;

   //百川信组织id
   private String bcxOrganizationId;

   //百川信职员id
   private String bcxEmployeeId;

   //签署方-对方
   private String userName;

   //签署方-对方手机号
   private String userMobile;

   //任务截止时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone="GMT+8")
   private Date taskExpiresTime;

   //任务完成时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
   private Date taskCompleteTime;

   //合同开始时间
   @JsonFormat(pattern = "yyyy-MM-dd", timezone="GMT+8")
   private Date contractStartTime;

   //合同到期时间
   @JsonFormat(pattern = "yyyy-MM-dd", timezone="GMT+8")
   private Date contractDueTime;

   //任务状态，1发起；2确认提交；3撤销；4过期；5作废；6签署中；10完成
   private Integer taskStatus;

   //法大大签署任务id
   private String fddSignTaskId;

   //任务附件OBS地址（任务完成后，自动下载，上传）
   private String taskFileObsUrl;

   //同步状态，1已同步；0未同步（劳动合同同步到员工合同，）
   private Integer syncStatus;

   //备注
   private String remark;

   //创建时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
   private Date createTime;

   //更新时间
   @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
   private Date updateTime;

}