package com.bcxin.fdd.dtos.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;


@Data
public class SignTaskCreateRequest {

    //百川信组织id
    @NotBlank(message = "组织id不能为空")
    private String bcxOrganizationId;

    //百川信职员id，任务类型是：劳动合同必填
    private String bcxEmployeeId;

    //任务类型，1-劳动合同，2-其他合同
    @NotNull(message = "任务类型不能为空")
    private Integer taskType;

    //任务名称
    @NotBlank(message = "任务名称不能为空")
    private String taskName;

    //签署方-对方
    private String userName;

    //签署方-对方手机号
    @NotBlank(message = "签署方-对方手机号不能为空")
    private String userMobile;

    //任务截止时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone="GMT+8")
    private Date taskExpiresTime;

    //合同开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone="GMT+8")
    private Date contractStartTime;

    //合同到期时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone="GMT+8")
    private Date contractDueTime;

    //备注
    private String remark;

}
