package com.bcxin.fdd.dtos.request;

import cn.hutool.core.date.DateUtil;
import lombok.Data;

import java.util.Date;
import java.util.UUID;


@Data
public class SharedMessageRequest {

    //id
    private String id;
    private String senderId;
    private String businessNumber;
    private String content;
    private String createdTime;
    private Integer messageType;
    private String receiver;
    private Integer receiverType;
    private Integer status;
    private String title;
    private String uniqueId;

    public SharedMessageRequest(String receiver, String title, String content) {
        String uuid = UUID.randomUUID().toString();
        this.id = uuid;
        this.senderId = uuid;
        this.businessNumber = uuid;
        this.content = content;
        this.createdTime = DateUtil.formatDateTime(new Date());
        this.messageType = 1;
        this.receiver = receiver;
        this.receiverType = 1;
        this.status = 0;
        this.title = title;
        this.uniqueId = uuid;
    }
}
