package com.bcxin.fdd.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.fdd.dtos.request.OrganizationOpenRequest;
import com.bcxin.fdd.dtos.request.SignTaskActorGetUrlRequest;
import com.bcxin.fdd.dtos.request.SignTaskCreateRequest;
import com.bcxin.fdd.dtos.response.GetFddUrlResponse;
import com.bcxin.fdd.dtos.response.result.RespResult;
import com.bcxin.fdd.service.BfOrganizationService;
import com.bcxin.fdd.service.BfSignTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Slf4j
@Controller
public class FddController {

    @Autowired
    private BfOrganizationService bfOrganizationService;
    @Autowired
    private BfSignTaskService bfSignTaskService;

    /**
     * 获取法大大企业授权链接
     */
    @ResponseBody
    @PostMapping("/api/fdd/corp/get-auth-url")
    public RespResult<GetFddUrlResponse> corpGetAuthUrl(@RequestBody @Validated OrganizationOpenRequest request) {
        log.info("获取企业授权链接，参数：{}", JSONObject.toJSONString(request));
        GetFddUrlResponse result = bfOrganizationService.getAuthUrl(request);
        log.info("获取企业授权链接，返回值：{}", result.getUrl());
        return RespResult.successful(result);
    }

    /**
     * 发起签署任务，并返回法大大签署任务编辑链接
     */
    @ResponseBody
    @PostMapping("/api/fdd/sign-task/create")
    public RespResult<GetFddUrlResponse> signTaskCreate(@RequestBody @Validated SignTaskCreateRequest request) {
        log.info("发起签署任务，参数：{}", JSONObject.toJSONString(request));
        GetFddUrlResponse result = bfSignTaskService.signTaskCreate(request);
        log.info("发起签署任务，返回值：{}", result.getUrl());
        return RespResult.successful(result);
    }

    /**
     * 获取签署任务编辑链接
     */
    @GetMapping("/api/fdd/sign-task/get-edit-url")
    public String signTaskGetEditUrl(SignTaskActorGetUrlRequest request) {
        log.info("获取签署任务编辑链接，参数：{}", JSONObject.toJSONString(request));
        GetFddUrlResponse result = bfSignTaskService.signTaskGetEditUrl(request);
        log.info("获取签署任务编辑链接，返回值：{}", result.getUrl());
        return "redirect:" + result.getUrl();
    }

    /**
     * 获取企业签署链接
     */
    @GetMapping("/api/fdd/sign-task/actor/get-url")
    public String signTaskActorGetUrl(SignTaskActorGetUrlRequest request) {
        log.info("获取企业签署链接，参数：{}", JSONObject.toJSONString(request));
        GetFddUrlResponse result = bfSignTaskService.signTaskActorGetUrl(request);
        log.info("获取企业签署链接，返回值：{}", result.getUrl());
        return "redirect:" + result.getUrl();
    }

    /**
     * 获取签署文档下载地址
     */
    @GetMapping("/api/fdd/sign-task/owner/get-download-url")
    public String getOwnerDownloadUrl(SignTaskActorGetUrlRequest request) {
        log.info("获取签署文档下载地址，参数：{}", JSONObject.toJSONString(request));
        GetFddUrlResponse result = bfSignTaskService.getOwnerDownloadUrl(request);
        log.info("获取签署文档下载地址，返回值：{}", result.getUrl());
        return "redirect:" + result.getUrl();
    }

}
