package com.bcxin.fdd.controller;


import com.bcxin.fdd.configs.FddConfig;
import com.bcxin.fdd.service.CallbackService;
import com.fasc.open.api.utils.crypt.FddCryptUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/**
 * description：法大大事件回调接口
 * author：linchunpeng
 * date：2024/8/15
 */
@Slf4j
@Controller
public class EventCallbackController {

    @Autowired
    private FddConfig fddConfig;
    @Autowired
    private CallbackService callbackService;

    /**
     * 法大大事件回调
     */
    @ResponseBody
    @PostMapping("/api/callback/fdd")
    public String fddCallback(@RequestHeader HttpHeaders headers,
                              @RequestParam("bizContent") String bizContent) {
        try {
            //获取请求头参数
            String appId = headers.getFirst("X-FASC-App-Id");
            String signType = headers.getFirst("X-FASC-Sign-Type");
            String sign = headers.getFirst("X-FASC-Sign");
            String timestamp = headers.getFirst("X-FASC-Timestamp");
            //事件名称，开发者可以根据不同事件名称去解析bizContent的值，实现不同的逻辑
            String event = headers.getFirst("X-FASC-Event");
            String nonce = headers.getFirst("X-FASC-Nonce");
            log.info("法大大事件回调，事件类型：{}，参数：{}", event, bizContent);
            //验签
            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("X-FASC-App-Id", appId);
            paramMap.put("X-FASC-Sign-Type", "HMAC-SHA256");
            paramMap.put("X-FASC-Timestamp", timestamp);
            paramMap.put("X-FASC-Nonce", nonce);
            paramMap.put("X-FASC-Event", event);
            paramMap.put("bizContent", bizContent);
            //参数排序，ascii码排序
            String sortParam = FddCryptUtil.sortParameters(paramMap);
            //生成签名后可以进行校验
            String signature =  FddCryptUtil.sign(sortParam, timestamp, fddConfig.getAppSecret());
            if(StringUtils.isBlank(event) || !signature.equals(sign)) {
                log.error("event为空 或 日志记录，签名失败");
                //为了不重复接收该请求，建议这里返回success，返回success后这条消息法大大将中断重试回调机制
                return "{\"msg\":\"success\"}";
            }
            callbackService.callback(event, bizContent);
        } catch (Exception e) {
            log.error("法大大事件回调异常，{}", e.getMessage(), e);
        }
        return "{\"msg\":\"success\"}";
    }

}
