package com.bcxin.fdd.common.utils;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * description：i人事请求
 * author：linchunpeng
 * date：2024/7/11
 */
public class IhrRequestUtil {

    private static final Logger logger = LoggerFactory.getLogger(IhrRequestUtil.class);

    //获取access_token
    private static final String  GET_ACCESS_TOKEN_URL = "https://openapi.ihr360.com/openapi/oauth/token?grant_type=client_credentials&scope=client";
    //批量创建部门
    private static final String  BATCH_CREATE_DEPARTMENT_URL = "https://openapi.ihr360.com/openapi/thirdparty/api/org/v1/organizations/create";
    //获取部门清单v2
    private static final String  GET_DEPARTMENT_URL = "https://openapi.ihr360.com/openapi/thirdparty/api/org/v2/companies/organizations";
    //批量创建员工
    private static final String  BATCH_CREATE_EMPLOYEE_URL = "https://openapi.ihr360.com/openapi/thirdparty/api/staff/v1/staffs/create";
    //根据员工证件类型和证件号获取员工ID
    private static final String  GET_STAFF_ID_BY_ID_CARD_TYPE_AND_ID_CARD_NO_URL = "https://openapi.ihr360.com/openapi/thirdparty/api/staff/v1/staffs/getStaffIdByIdCardTypeAndIdCardNo";
    //批量新增（修改）排班分组
    private static final String  BATCH_CREATE_ATTENDANCE_SITE_URL = "https://openapi.ihr360.com/openapi/thirdparty/api/tm/v1/schedule/group/createOrUpdate";

    //i人事AppID
    private String appId;
    //i人事AppSecret
    private String appSecret;
    //i人事accessToken
    private String accessToken;

    public IhrRequestUtil(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.accessToken = getAccessToken(appId, appSecret);
    }

    /**
     * 获取access_token，返回accessToken
     */
    private String getAccessToken(String appId, String appSecret) {
        String accessToken = null;
        String authorization = "Basic ".concat(Base64.encode(appId.concat(":").concat(appSecret)));
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.post(GET_ACCESS_TOKEN_URL, "{}", headerMap);
        if ("fail".equals(result)) {
            logger.error("初始化accessToken失败");
        } else {
            accessToken = JSONObject.parseObject(result).getString("access_token");
        }
        return accessToken;
    }

    /**
     * 批量创建部门，返回i人事部门id列表
     */
    public List<Long> batchCreateDepartment(List<Map<String, Object>> param) {
        List<Long> resultList = new ArrayList<>();
        String authorization = "Bearer ".concat(this.accessToken);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.post(BATCH_CREATE_DEPARTMENT_URL, JSONObject.toJSONString(param), headerMap);
        if ("fail".equals(result)) {
            logger.error("批量创建部门失败");
        } else {
            JSONObject resultObj = JSONObject.parseObject(result);
            Integer code = resultObj.getInteger("code");
            if (code == 0) {
                JSONArray data = resultObj.getJSONArray("data");
                for (int i = 0; i < data.size(); i++) {
                    resultList.add(data.getLong(i));
                }
            } else {
                logger.error("批量创建部门失败");
            }
        }
        return resultList;
    }

    /**
     * 批量创建部门，返回i人事部门id列表
     */
    public Long getRootDepartmentId() {
        String authorization = "Bearer ".concat(this.accessToken);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.get(GET_DEPARTMENT_URL, headerMap);
        if ("fail".equals(result)) {
            logger.error("批量创建部门失败");
        } else {
            JSONArray data = JSONObject.parseObject(result).getJSONArray("data");
            for (int i = 0; i < data.size(); i++) {
                Long parentId = data.getJSONObject(i).getLong("parentId");
                if (parentId != null && parentId == -1) {
                    return data.getJSONObject(i).getLong("id");
                }
            }
        }
        return null;
    }

    /**
     * 批量创建员工，返回i人事员工id列表（每次最多100个）
     */
    public Map<String, String> batchCreateEmployee(List<Map<String, Object>> param) {
        Map<String, String> resultMap = new HashMap<>();
        String authorization = "Bearer ".concat(this.accessToken);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.post(BATCH_CREATE_EMPLOYEE_URL, JSONObject.toJSONString(param), headerMap);
        if ("fail".equals(result)) {
            logger.error("批量创建员工失败");
        } else {
            JSONObject resultObj = JSONObject.parseObject(result);
            Integer code = resultObj.getInteger("code");
            if (code == 0) {
                for (Map<String, Object> map : param) {
                    Map<String, Object> getIdMap = new HashMap<>();
                    getIdMap.put("idCardType", map.get("idCardType"));
                    getIdMap.put("idCardNo", map.get("idCardNo"));
                    String staffId = this.getStaffIdByIdCardTypeAndIdCardNo(getIdMap);

                    resultMap.put(map.get("idCardNo").toString(), staffId);
                }
            } else {
                logger.error("批量创建员工失败");
            }
        }
        return resultMap;
    }


    /**
     * 根据员工证件类型和证件号获取员工ID
     */
    private String getStaffIdByIdCardTypeAndIdCardNo(Map<String, Object> param) {
        String authorization = "Bearer ".concat(this.accessToken);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.get(GET_STAFF_ID_BY_ID_CARD_TYPE_AND_ID_CARD_NO_URL + "?" + toUrlParams(param), headerMap);
        if ("fail".equals(result)) {
            logger.error("根据员工证件类型和证件号获取员工ID失败");
        } else {
            JSONObject resultObj = JSONObject.parseObject(result);
            Integer code = resultObj.getInteger("code");
            if (code == 0) {
                String staffId = resultObj.getJSONObject("data").getString("staffId");
                logger.info("staffId={}", staffId);
                return staffId;
            } else {
                logger.error("根据员工证件类型和证件号获取员工ID失败");
            }
        }
        return null;
    }

    public static String toUrlParams(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = params.keySet();
        for (String key : keys) {
            sb.append(key).append("=").append(params.get(key).toString());
            sb.append("&");
        }
        // 删除最后一个多余的'&'
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    /**
     * 批量新增（修改）排班分组（每次最多20个）
     */
    public Map<String, String> batchCreateAttendanceSite(String ihrOrganizationId, List<Map<String, Object>> param) {
        Map<String, String> resultMap = new HashMap<>();
        String authorization = "Bearer ".concat(this.accessToken);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", authorization);
        String result = HttpUtil.post(BATCH_CREATE_ATTENDANCE_SITE_URL + "?companyId=" + ihrOrganizationId, JSONObject.toJSONString(param), headerMap);
        if ("fail".equals(result)) {
            logger.error("批量新增（修改）排班分组失败");
        } else {
            JSONObject resultObj = JSONObject.parseObject(result);
            Integer code = resultObj.getInteger("code");
            if (code == 0) {

            } else {
                logger.error("批量新增（修改）排班分组失败");
            }
        }
        return resultMap;
    }
}
