package com.bcxin.fdd.ascept;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.fdd.common.utils.AssertUtils;
import com.bcxin.fdd.common.utils.TokenUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * description：鉴权切面
 * author：linchunpeng
 * date：2023/11/7
 */
@Slf4j
@Component
@Aspect
public class AuthAspect {

    /**
     * 路径校验器
     */
    private AntPathMatcher antPathMatcher =  new AntPathMatcher();

    /**
     * description：环绕切面
     * author：linchunpeng
     * date：2023/11/15
     */
    @Around("execution(* com.bcxin.fdd.controller.*.*(..))")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();

        if(this.isMatch(request.getRequestURI(), getPublicUris())) {
            return proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
        }
        //取出授权信息
        String accesstoken = TokenUtils.getBcxToken(request);
        AssertUtils.isNotEmptyString(accesstoken, "Accesstoken不能为空");

        String employeeId = TokenUtils.getEmployeeIdFromBcxToken(accesstoken);
        AssertUtils.isNotEmptyString(employeeId, "无效的Accesstoken");

        log.info("=========================================================================================");
        log.info("请求地址：{}，请求参数：{}",
                request.getRequestURI(), proceedingJoinPoint.getArgs());
        log.info("=========================================================================================");

        //验证appid 与 sender，是否绑定
        Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());

        log.info("=========================================================================================");
        log.info("请求地址：{}，返回参数：{}",
                request.getRequestURI(), JSONObject.toJSONString(proceed));
        log.info("=========================================================================================");
        return proceed;
    }

    /**
     * description：实付匹配
     * author：linchunpeng
     * date：2023/11/15
     */
    private boolean isMatch(String url, List<String> uris) {
        if(uris==null){
            return false;
        }
        for (String uri : uris) {
            if (this.antPathMatcher.match(uri, url)) {
                return true;
            }
        }
        return false;
    }

    /**
     * description：不需要鉴权的接口url
     * author：linchunpeng
     * date：2023/11/15
     */
    private List<String> getPublicUris() {
        return Arrays.asList("/api/callback/fdd");
    }
}
