package com.bcxin.ars.timer.train;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.util.Constants;

/***
 * 培训考试信息、人员定时更新
 * 
 * @author wangjianchi
 * @since 1.1
 */
@Service
public class TrainExamInfoPersonService {
	private Logger logger = LoggerFactory.getLogger(TrainExamInfoPersonService.class);
	@Autowired
	private TrainExamInfoService trainExamInfoService;
	@Autowired
	private ConfigDao configDao;
	@Value("${timeFlag}")
	private String timeFlag = "";

	public void run() {
		try {

			Config config = configDao.findByKey("police");
			if (config != null) {
				// 外网
				if (config.getValue().equals("0") && timeFlag.equals("true")) {
					// 在线缴费
					config = configDao.findByKey(Constants.IS_ONLINEPAY);
					if (config.getValue().equals("1")) {
						// 获取当前省份
						config = configDao.findByKey(Constants.CURRENT_PROVINCE);
						if (config.getValue().length() > 2) {
							// 同步百课堂考试安排、人员信息到百保盾
							trainExamInfoService.saveExamInfoFromTrain(config.getValue().substring(0, 2));
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}

}