package com.bcxin.ars.timer.task.status;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoUpdateStatusServiceV2 {
    private Logger logger = LoggerFactory.getLogger(AutoUpdateStatusServiceV2.class);
    @Autowired
    private ComTaskService comTaskService;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${timeFlag}")
    private String timeFlag = "";

    public void updateStatus() {
		/*//查询  是否与saas对接 配置信息
		Config saasJoin = configUtils.getConfigByKey(Constants.SaaSJoin);
		if(saasJoin != null && Constants.SaaSJoin_YES.equals(saasJoin.getValue())){
			//与saas对接的，不执行定时器
			return;
		}*/

        Config config = configUtils.getConfigByKey("police");
        // 外网
        if (config.getValue().equals(Constants.POLICE_OUT) && timeFlag.equals("true")) {
            logger.info("begin to update task statusV2...");
            //定时器更新驻勤状态和合同状态
            comTaskService.updateStatusV2();
            logger.info("update task statusV2 done.");
        }
    }

}
