package com.bcxin.ars.timer.report;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.report.*;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 首页统计数据生成
 * @author linqinglin
 * @date 2019/11/28 0028 15:29
 */
@Service
public class IndexReportService {

    Logger logger = LoggerFactory.getLogger(IndexReportService.class);

    @Autowired
    private ReportProblemPersonService reportProblemPersonService;

    @Autowired
    private ReportPersonService reportPersonService;

    @Autowired
    private ReportCompanyService reportCompanyService;

    @Autowired
    private ReportPersoncertificateService reportPersoncertificateService;

    @Autowired
    private ReportTaskService reportTaskService;

    @Autowired
    private ReportTrainService reportTrainService;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${timeFlag}")
    private String timeFlag = "";

    public void generateReport(){

        if(Constants.BEIJING.equals(configUtils.getCurrentNative())  && timeFlag.equals("true")){
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();

            //使用线程池
            CountDownLatch workCount = ThreadUtil.newCountDownLatch(6);
            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(6, 6);

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportProblemPersonService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportPersonService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportCompanyService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportTrainService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportPersoncertificateService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });

            threadPoolExecutor.execute(new Runnable(){
                @Override
                public void run() {
                    try {
                        reportTaskService.generateReport();
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    } finally {
                        workCount.countDown();
                    }
                }
            });


            try {
                //线程等待全部完成
                workCount.await();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(),e);
                Thread.currentThread().interrupt();
            }finally {
                threadPoolExecutor.shutdown();
            }

            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(IndexReportService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);

        }

    }

}
