package com.bcxin.ars.timer.personcertificate;


import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.PersonImgDao;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.PersonImg;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.PhotoUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.GetPersonImgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


/***
 * 非结构化文件存储优化
 */
@Service
public class PersonImgToPersonBaseInfoService {

    private Logger logger = LoggerFactory.getLogger(PersonImgToPersonBaseInfoService.class);


    @Autowired
    GetPersonImgUtil getPersonImgUtil;

    @Autowired
    PersonImgDao personImgDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Autowired
    private PhotoUtil photoUtil;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    private boolean lock = false;

    public void run() {

        if(lock){
            return;
        }
        lock = true;

        try {
            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag) && configUtils.isIntranet()) {

                if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try{
                    List<PersonImg> list = personImgDao.findUnChageList();
                    List<PersonBaseInfo> saveList = new ArrayList<>();
                    if(list.size() > 0){
                        PersonBaseInfo personBaseInfo = null;
                        for (PersonImg personImg : list) {
                            try {
                                personBaseInfo = new PersonBaseInfo();
                                personBaseInfo.setIdnum(personImg.getIdNumber());
                                personBaseInfo.setPhoto(GetPersonImgUtil.getImageString(personImg.getIdImage()));
                                personBaseInfo.setUpdateflag(true);
                                personBaseInfo.setActive(true);
                                personBaseInfo.setCreateTime(new Date());
                                personBaseInfo.setUpdateTime(new Date());
                                if(list.size() == 500) {
                                    photoUtil.saveRandomPhoto(personBaseInfo);
                                }else{
                                    photoUtil.savePhoto(personBaseInfo);
                                }
                                saveList.add(personBaseInfo);
                            }catch (Exception e) {
                                logger.error(e.getMessage(),e);
                            }
                        }

                        if(saveList.size()>0){
                            int limit = 100;
                            //计算拆分次数
                            int count = new Double(Math.ceil(saveList.size() * 1.0 / limit)).intValue();
                            //存放拆分数据
                            List<PersonBaseInfo> subList = null;
                            //循环拆分次数 生成相应数据文件
                            for (int i = 0; i < count; i++) {
                                subList = saveList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                                personBaseInfoDao.saveBatch(subList);
                            }
                        }
                    }


                } catch (Exception e) {
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(PersonImgToPersonBaseInfoService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }finally {
            lock = false;
        }
    }
}
