package com.bcxin.ars.timer.personGrade;

import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 保安员等级证报名自动背景筛查
 */
@Service
public class PersonGradeCensorStatusService {
    /***
     * 日志
     */
    private static  final  Logger logger = LoggerFactory.getLogger(PersonGradeCensorStatusService.class);

    @Autowired
    private PersonGradeDao personGradeDao;

    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;

    @Value("${timeFlag}")
    private String timeFlag = "";

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private JobRunLogService jobRunLogService;

    private static BackGroupCensorService backGroupCensorService;

    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }


    public void run() {
        if (configUtils.isIntranet() && timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                getBackGroupCensorService();
                /****
                 * 未背景筛查列表
                 */
                List<PersonGrade> personList = personGradeDao.findNoCensorStatus();
                if (personList != null && personList.size() > 0) {
                    for (PersonGrade personGrade : personList) {
                        this.getCensorStatus(personGrade);
                    }
                    /***
                     * 批量更新
                     */
                    personGradeDaoAop.saveBatch(personList);
                }
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(PersonGradeCensorStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }

    private void getCensorStatus(PersonGrade personGrade){
        try {
            Boolean pass = true;
            Date now = new Date();
            //背景筛查开始
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personGrade.getId());
            backgroundApprovalDto.setBusinesstype(Constants.PERSONGRADE_CENSORSTATUS);
            backgroundApprovalDto.setIdNumber(personGrade.getIdNum());
            backgroundApprovalDto.setRealName(personGrade.getName());

            //背景筛查
            List<BackgroundApproval> list = backGroupCensorService.censor(backgroundApprovalDto);

            //查询结果
            String approvalReason = null;
            //背景筛查结果为空则证明背景筛查异常
            if(list == null || list.size()==0){
                return;
            }
            for (BackgroundApproval backgroundApproval : list) {
                if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                    if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                        approvalReason = "背景筛查不通过，原因：" + backgroundApproval.getApprovalreason();
                    } else {
                        approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                    }
                    pass = false;
                    break;
                }
            }
            personGrade.setApprovalReason(approvalReason);
            if (pass) {
                //背景筛查通过
                personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
                //审批中
                personGrade.setApprovalState(Constants.APPLYSTATUS_DSH);
            } else {
                //背景筛查不通过
                personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
                //审批中
                //#6085573 【公安】现由于添加了申诉入口，等级证报名后背景筛查不通过，审批状态应该变成“审核中”，如果申诉后背景筛查不通过，审批状态才变为“审批不通过”
                personGrade.setApprovalState(Constants.APPLYSTATUS_DSH);
            }
            //更新背景筛查状态
            personGrade.setUpdateTime(now);
            personGrade.setUpdateflag(true);
            personGrade.setInTime(now);
        }catch (Exception e){
            logger.error("异常"+personGrade.getIdNum());
        }
    }
}
