package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * 内外网数据同步外到内
 * 需要同步的表在service实现类加上DataSyncAnnotation注解
 * service实现类中
 *  读取同步数据文件实现saveOrUpdateForDS或updateFlagForOutToIn
 *  生成同步数据文件实现searchForDataSynchronization
 * @author linqinglin
 * @date 2019/04/03 14:15
 */
@Service
public class DataSyncO2IService {

    private Logger logger = LoggerFactory.getLogger(DataSyncO2IService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ConfigDao configDao;

    @Autowired
    private DataSyncUtil dataSyncUtil;

    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;

    @Autowired
    private JobRunLogService jobRunLogService;

    /***
     *  增量数据
     */
    private boolean lock = false;
    public void run() {
        if(lock){
            return;
        }
        lock = true;

        try {

            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {
                if (!Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    if (configUtils.isIntranet()) {
                        //内网读取同步文件
                        readDSFile();
                    } else {
                        createDataFile();
                    }
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncO2IService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }
    private void readDSFile() {
        Date now = new Date();
        /***
         * 最后同步日期
         */
        Config lastDateConfig = configDao.findByKey(Constants.LASTDATE);
        if (lastDateConfig != null) {
            //读取的时间为最后更新的时间
            String lastDate = lastDateConfig.getValue();
            List<Date> dates = DateUtil.getBetweenDates(DateUtil.convertStringToDate(lastDate), now);
            //加入当前日期
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = dataSyncContantsUtil.ftpOutFolder + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) {
                    break;
                }
                File[] files = dirFile.listFiles();
                //读取是否有错误
                boolean errorFlag = false;
                for (int i = 0; i < files.length; i++) {
                    File file = files[i];
                    if(file.getName().endsWith(Constants.ZIP) && file.getName().startsWith(configUtils.getDataSyncStartFileName(DataSyncAnnotation.class))){
                        try {
                            dataSyncUtil.readDSFile(DataSyncAnnotation.class,file);
                        } catch (Exception e) {
                            logger.error(e.getMessage(), e);
                            errorFlag = true;
                        }
                    }
                }
                //如果文件没有读取错误
                if (!errorFlag) {
                    Config updateConfig = new Config();
                    updateConfig.setKey(Constants.LASTDATE);
                    updateConfig.setValue(DateUtil.convertDateToString(date, DateUtil.FORMAT2));
                    configUtils.updateForKey(updateConfig);
                }

            }
        }
    }

    /**
     * 内网生成数据同步文件
     */
    private void createDataFile(){

        DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
        searchDto.setPaging(false);
        /***
         * 最后同步日期
         */
        Config lastDateConfig = configUtils.getConfigByKey(Constants.LASTDATETIME);
        //配置为空或者等于当天日期
        if (lastDateConfig == null || DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2).equals(lastDateConfig.getValue())) {
            searchDto.setStartDate(DateUtil.getYesterdayTime());
        } else {
            //设置为最后同步日期
            searchDto.setStartDate(lastDateConfig.getValue());
        }
        searchDto.setEndDate(DateUtil.getTomorrowTime());
        //外网生成同步文件
        dataSyncUtil.createDSFile(DataSyncAnnotation.class,searchDto,dataSyncContantsUtil.ftpOutFolder + DateUtil.getCurrentDate()+File.separator);

        /**
         * 更新"外到内最后同步日期" start
         */
        Config updateConfig = new Config();
        updateConfig.setKey(Constants.LASTDATETIME);
        updateConfig.setValue(DateUtil.getDateStrAfterMinute(-5));
        updateConfig.setUpdateTime(new Date());
        configUtils.updateForKey(updateConfig);
        /**
         * 更新"外到内最后同步日期" end
         */

    }

}
