package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * 同步30天内的数据
 * 内外网数据同步
 * 需要同步的表在service实现类加上DataSyncAnnotation注解
 * service实现类中
 *  读取同步数据文件实现saveOrUpdateForDS或updateFlagForOutToIn
 *  生成同步数据文件实现searchForDataSynchronization
 * @author linqinglin
 * @date 2019/04/03 14:15
 */
@Service
public class DataSyncDSOneMonthService {

    private Logger logger = LoggerFactory.getLogger(DataSyncDSOneMonthService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private DataSyncUtil dataSyncUtil;

    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;

    private boolean lock = false;
    /***
     *  增量数据
     */
    @JobLogAnnotation(getJobClazz =DataSyncDSOneMonthService.class)
    public void run() {
        if(lock){
            return;
        }
        lock = true;

        try {
            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {
                //获取配置是否要同步
                Config datasynchronizationconfig = configUtils.getConfigByKey(Constants.DATASYNCHRONIZATION);
                //同步
                if (datasynchronizationconfig != null
                        && Constants.DATASYNCHRONIZATION_YES.equals(datasynchronizationconfig.getValue())) {
                    Config config = configUtils.getConfigByKey(Constants.POLICE);
                    if (config != null && Constants.POLICE_IN.equals(config.getValue())) {
                        //内网读取同步文件
                        policeInReadFile();
                    }
                }
            }
        }finally {
            lock = false;
        }
    }
    private void policeInReadFile() {
        Date now = new Date();
        /***
         * 最后同步日期
         */
        //读取的时间为最后更新的时间
        String lastDate = DateUtil.convertDateToString(DateUtil.getBeginDayOfLastMonth(),DateUtil.FORMAT2);
        try {
            lastDate = DateUtil.dateAdd(15,DateUtil.getCurrentDate(),-30);
        } catch (Exception e) {
            e.printStackTrace();
        }
        List<Date> dates = DateUtil.getBetweenDates(DateUtil.convertStringToDate(lastDate), now);
        for (Date date : dates) {
            String dirFilePath = dataSyncContantsUtil.ftpFolder + DateUtil.convertDateToString(date, DateUtil.FORMAT2);

            if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
                dirFilePath = dataSyncContantsUtil.ftpOutFolder + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
            }

            File dirFile = new File(dirFilePath);
            if (!dirFile.exists()) {
                continue;
            }
            File[] files = dirFile.listFiles();
            for (int i = 0; i < files.length; i++) {
                File file = files[i];
                if(file.getName().endsWith(Constants.ZIP) && file.getName().startsWith(configUtils.getDataSyncStartFileName(DataSyncAnnotation.class))){
                    try {
                        dataSyncUtil.readDSFile(DataSyncAnnotation.class,file);
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
        }
    }

}
