package com.bcxin.ars.timer.dataSync;

import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EmailUtils;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2020/12/09 0009 10:51
 */
@Service
public class DataSyncAlarmService {

    private Logger logger = LoggerFactory.getLogger(DataSyncAlarmService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private DataSyncLogDao dataSyncLogDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private JobRunLogService jobRunLogService;


    private boolean lock = false;
    public void run() {
        if(lock){
            return;
        }
        lock = true;
        try {

            if(Constants.NINGXIA.equals(configUtils.getCurrentNative())){
                return;
            }

            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag) && !configUtils.isIntranet()) {

                String receiveUser = configUtils.getValueByKey(Constants.DATASYNC_RECEIVEUSER);
                if(StringUtil.isEmpty(receiveUser)){
                    return;
                }

                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))) {

                        if(!Constants.YES.equals(configUtils.getValueByKey(Constants.DATASYNC_INTERFACE_SWITCH))){
                            return;
                        }

                        String unDSTime = dataSyncLogDao.findUnDSTime();
                        if (StringUtil.isNotEmpty(unDSTime)) {
                            DateUtil.hourDiff(DateUtil.convertStringToDate(unDSTime), new Date());
                            if (DateUtil.hourDiff1(DateUtil.convertStringToDate(unDSTime), new Date(), DateUtil.FORMAT1) > 1) {
                                new Thread(() -> {
                                    String sendHtml = Constants.DATASYNC_SENDHTML_TOFTP.replace("{lastDate}", unDSTime)
                                            .replace("{currentNativeName}", configUtils.getValueByKey(Constants.CURRENT_NATIVE_NAME))
                                            .replace("url", configUtils.getWebHost());
                                    EmailUtils emailUtil = new EmailUtils();
                                    emailUtil.sendEmail(Constants.DATASYNC_SUBJECT, sendHtml, receiveUser);
                                }).start();

                                return;
                            }
                        }
                    }

                    String unCensorTime = personcertificateDao.findUnCensorTime();

                    int overTime = 5;
                    try {
                        String overTimeConfig = configUtils.getValueByKey(Constants.DATASYNC_ALARM_TIME);
                        if(StringUtil.isNotEmpty(overTimeConfig)) {
                            overTime = Integer.parseInt(overTimeConfig);
                        }
                    }catch (Exception e){

                    }
                    if(StringUtil.isNotEmpty(unCensorTime)){
                        DateUtil.hourDiff(DateUtil.convertStringToDate(unCensorTime),new Date());
                        if(DateUtil.hourDiff1(DateUtil.convertStringToDate(unCensorTime),new Date(),DateUtil.FORMAT1)> overTime){
                            new Thread(()->{
                                String sendHtml = Constants.DATASYNC_SENDHTML_UNCENSOR.replace("{lastDate}", unCensorTime)
                                        .replace("{currentNativeName}", configUtils.getValueByKey(Constants.CURRENT_NATIVE_NAME))
                                        .replace("url",configUtils.getWebHost());
                                EmailUtils emailUtil = new EmailUtils();
                                emailUtil.sendEmail(Constants.DATASYNC_SUBJECT, sendHtml, receiveUser);
                            }).start();
                        }
                    }
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncAlarmService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);

            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            lock = false;
        }
    }
}
