package com.bcxin.ars.timer.company;

import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.sb.ManagementInfoDto;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公司管理层信息不完整通知
 *
 * @author zhangyutong
 */
@Service
public class ManagerInfoIncompleteNotifyService {


    private static final Logger logger = LoggerFactory.getLogger(ManagerInfoIncompleteNotifyService.class);

    @Resource
    private JobRunLogService jobRunLogService;

    @Resource
    private SAASInterfaceUtil saasInterfaceUtil;

    @Resource
    private ConfigUtils configUtils;

    @Resource
    private ManagementInfoDao managementInfoDao;

    public void run() {
        // 判断是否是 北京外网环境
        if (!Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)
                || !Constants.BEIJING.equals(configUtils.getCurrentNative())
                || configUtils.isIntranet()) {
            return;
        }

        // 记录日志
        JobRunLog log = getJobRunLog();
        long startTime = System.currentTimeMillis();
        try {
            // 处理数据
            handleInfoIncomplete();
        } catch (RuntimeException e) {
            logger.error("管理层信息不全站内信提醒异常:{}", e.getMessage());
            e.printStackTrace();
        } finally {
            long endTime = System.currentTimeMillis();
            log.setRunTimeLength((endTime - startTime) + "ms");
            log.setUpdateTime(new Date());
            // 保存日志
            jobRunLogService.insert(log);
        }

    }

    /**
     * 逻辑方法
     */
    public void handleInfoIncomplete() {
        // 先查出公司
        List<ManagementInfoDto> managers = managementInfoDao.listWithComId();

        // 2021-03-08 刘昭伟 校验所有管理层的职务信息字段，是否满足包含“法、总、副”字样；若有则不提示，若无则提示完善信息；
        Map<String,List<ManagementInfoDto>> manageMap = managers.stream().collect(Collectors.groupingBy(ManagementInfoDto::getComId));

        Map<String, String> noJobMap = new HashMap<>();

        String comId = null;
        String comIds = null;
        String jobs = null;
        List<ManagementInfoDto> manageList = null;

        for (Map.Entry<String, List<ManagementInfoDto>> entry : manageMap.entrySet()) {
            comId = entry.getKey();
            manageList = entry.getValue();
            jobs = "";
            boolean frJob = false;
            boolean zjlJob = false;
            boolean fzjlJob = false;
            boolean sjfzrJob = false;
            for (ManagementInfoDto managementInfoDto : manageList) {
                if(StringUtil.isNotEmpty(managementInfoDto.getJobName())){
                    if(managementInfoDto.getJobName().contains("法")){
                        frJob = true;
                    }
                    if(managementInfoDto.getJobName().contains("副")){
                        fzjlJob = true;
                    }
                    if(managementInfoDto.getJobName().contains(Constants.CHARGE_REPRESENTATIVE)){
                        sjfzrJob = true;
                    }
                    if(managementInfoDto.getJobName().replaceAll("总监","").replaceAll(Constants.DEPUTY_GENERAL_MANAGER,"").contains("总")){
                        zjlJob =true;
                    }
                }
            }

            if(!frJob){
                jobs = jobs + Constants.LEGAL_REPRESENTATIVE + Constants.COMMA;
            }
            if(!zjlJob){
                jobs = jobs + Constants.GENERAL_MANAGER + Constants.COMMA;
            }
            if(!fzjlJob){
                jobs = jobs + Constants.DEPUTY_GENERAL_MANAGER + Constants.COMMA;
            }
            if(!sjfzrJob){
                jobs = jobs + Constants.CHARGE_REPRESENTATIVE + Constants.COMMA;
            }

            if(StringUtil.isNotEmpty(jobs)) {
                comIds = noJobMap.get(jobs);
                if(StringUtil.isEmpty(comIds)){
                    comIds = comId;
                }else{
                    comIds = comIds + Constants.COMMA + comId;
                }
                noJobMap.put(jobs,comIds);
            }
        }

        noJobMap.forEach((jobNames,ids)->{
            send(ids,Constants.MESSAGE_COMPANY_MANAGEMENT_INFO_INCOMPLETE_TITLE,Constants.MESSAGE_COMPANY_MANAGEMENT_INFO_INCOMPLETE_CONTENT.replace("{jobs}",jobNames));
        });
    }

    /**
     * 日志
     *
     * @return 日志对象
     */
    private JobRunLog getJobRunLog() {
        // 设置日志记录
        JobRunLog log = new JobRunLog();
        log.setCreateTime(new Date());
        log.setJobName(this.getClass().getName());
        log.setActive(true);
        log.setUpdateBy("jobSystem");
        log.setRunTime(new Date());
        return log;
    }

    /**
     * 发送消息的方法,调用对方接口发站内信
     *
     * @param companyIds 公司id集合
     * @param title      消息头
     * @param content    消息体
     * @return 返回结果
     */
    public AjaxResult send(String companyIds,
                           String title,
                           String content) {
        logger.info(companyIds);
        logger.info(content);
        SAASMessageDto saasMessageDto = new SAASMessageDto();
        saasMessageDto.setComIds(companyIds);
        saasMessageDto.setTitle(title);
        saasMessageDto.setContent(content);
        saasMessageDto.setPoliceRegionId(configUtils.getCurrentProvince());
        saasMessageDto.setMessageType(Constants.MESSAGETYPE_050303);
        return saasInterfaceUtil.sendSaasMsg(saasMessageDto);
    }
}
