package com.bcxin.ars.timer.bdgk;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Bdgk_ba;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.Bdgk_baService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

@Service
public class BdgkServiceJob {
    private Logger logger = LoggerFactory.getLogger(BdgkServiceJob.class);
    @Value("${ZAFLAG}")
    private String ZAFLAG;
    @Autowired
    private Bdgk_baService bdgk_baService;
    @Autowired
    private ConfigUtils configUtils;
    @JobLogAnnotation(getJobClazz = BdgkServiceJob.class)
    public void run() {
        //判断是否为公安内网，只有内网才背景筛查
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        if(Constants.ISPOLICE_YES.equals(config.getValue())&& ZAFLAG!=null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
            List<Bdgk_ba> list =  bdgk_baService.findAll();
            if(list!=null && list.size()>0){
                CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch(list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(50, 50);
                for (Bdgk_ba bdgkBa : list) {
                    threadPoolExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                    bdgk_baService.update(bdgkBa);
                            } catch (Exception e) {
                                logger.error(e.getMessage(), e);
                            } finally {
                                countDownLatch.countDown();
                            }
                        }
                    });
                }
                try {
                    //线程等待全部完成
                    countDownLatch.await();
                } catch (InterruptedException e) {
                    logger.error(e.getMessage(),e);
                    Thread.currentThread().interrupt();
                }finally {
                    threadPoolExecutor.shutdown();
                }
            }


        }
    }
}
