package com.bcxin.ars.timer;

import cn.jiguang.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.BankAccountDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sys.BankAccount;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2020/07/21 0021 15:22
 */
@Service
public class BankAccountToSaasService {

    private Logger logger = LoggerFactory.getLogger(BankAccountToSaasService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private BankAccountDao bankAccountDao;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Value("${timeFlag}")
    private String timeFlag = "";

    @Autowired
    private JobRunLogService jobRunLogService;

    public void sendToSaas(){
        if(Constants.BEIJING.equals(configUtils.getCurrentNative()) && !configUtils.isIntranet() && timeFlag.equals("true")){
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try{
                List<BankAccount> list = bankAccountDao.findUnPushToSAAS();
                //根据数据数量情况，切分不同的大小
                int limit = 200;
                //计算拆分次数
                int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
                //存放拆分数据
                List<BankAccount> subList = null;

                JSONArray paramArr = null;
                JSONObject param = null;
                //循环拆分次数 生成相应数据文件
                for (int i = 0; i < count; i++) {
                     try {
                         subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());

                         paramArr = new JSONArray();
                         for (BankAccount bankAccount : subList) {
                             bankAccount.setPush(true);
                             bankAccount.setUpdateTime(new Date());
                             param = new JSONObject();
                             param.put("perId", bankAccount.getPerId()); // 人员ID
                             param.put("activeTime", bankAccount.getActiveDate());// 激活时间
                             param.put("openCardTime", bankAccount.getCardDate());// 开卡时间
                             param.put("bankCode", "CBHB");// 银行编码 渤海银行都写CBHB
                             param.put("bankOutlets", bankAccount.getBankName()); // 开户行
                             if (StringUtil.isNotEmpty(bankAccount.getInitial())) {
                                 if (Constants.YES.equals(bankAccount.getInitial())) {
                                     param.put("isActive", Constants.NO); // 是否激活
                                 }
                                 if (Constants.NO.equals(bankAccount.getInitial())) {
                                     param.put("isActive", Constants.YES); // 是否激活
                                 }
                             }
                             param.put("bankNo", bankAccount.getBankNo()); // 开户行行号
                             param.put("bankCardNo", bankAccount.getCarNo()); // 银行卡号
                             param.put("bankAccountStatus", bankAccount.getState()); // 银行账户状态 0 注销 1正常
                             param.put("bankAccountType", bankAccount.getBankAccountType()); // 账户类型 编码值 ，1为I类卡，2为II类卡

                             if (StringUtils.isNotEmpty(bankAccount.getFreezeDate())) {
                                 param.put("cancelTime", bankAccount.getFreezeDate()); // 注销时间
                             }
                             if (StringUtils.isNotEmpty(bankAccount.getReason())) {
                                 param.put("cancelReason", bankAccount.getReason()); // 注销原因
                             }
                             paramArr.add(param);
                         }
                         //TODO
                         Map<String, Object> paramMap = new HashMap<>();
                         paramMap.put("perJointlys", JSONObject.toJSONString(paramArr));
                         AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_SAVE_BANKACCOUNT, paramMap);
                         if (result.isSuccessful()) {
                             bankAccountDao.saveBatch(list);
                         }
                     }catch (Exception e){
                         e.printStackTrace();
                     }
                }
            }catch (Exception e ){
                //异常信息存储
                e.printStackTrace();
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.getMessage());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(BankAccountToSaasService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);

        }

    }
}
