package com.bcxin.ars.timer;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.gx.GXSSODao;
import com.bcxin.ars.model.GXSSO;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class AutoCancellationProjectNoService {
    private static Logger logger = LoggerFactory.getLogger(AutoCancellationProjectNoService.class);
    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private GXSSOUtil gxssoUtil;

    @Autowired
    private GXSSODao gxssoDao;

    private boolean lock = false;

    public void run() {
        if (lock) {
            return;
        }
        lock = true;

        try {

            if (Constants.GUANGXI.equals(configUtils.getCurrentNative()) && !configUtils.isIntranet()) {
                List<GXSSO> gxssos = gxssoDao.findUnComplete();
                for (GXSSO gxsso:gxssos
                     ) {
                    gxssoUtil.destroyProjectNo(gxsso.getProjectNo());
                }



            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            lock = false;
        }

    }
}
