package com.bcxin.ars.service.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.TaskTrack;

/**
 * 任务轨迹服务类
 * @author Ethan
 */
public interface TaskTrackService {

	/**
	 * 新增任务轨迹
	 * @param track 轨迹信息，经纬度
	 * @return
	 */
	Long save(TaskTrack track);
	/**
	 * 新增任务轨迹用于SaaS
	 * @param track 轨迹信息，经纬度
	 * @return
	 */
	Long saveForSaaS(TaskTrack track);
	/**
	 * 根据任务和人员获取轨迹列表
	 * @param feedbackId
	 * @return
	 */
	List<TaskTrack> findByFeedbackId(Long feedbackId);

	List<TaskTrack> searchForDataSynchronization( DataSynchronizationSearchDto searchDto);
	
}
