package com.bcxin.ars.service;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PoliceUserDto;
import com.bcxin.ars.dto.page.UserPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.model.User;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * 账户服务类
 * @author Ethan
 */
public interface UserService {
	/**
	 *
	 * @Decription:查找所有的公司用户
	 * @author：zhongjianhui
	 * @method  searchAllCompanyUser
	 * @date：2018/6/21 9:26
	 * @params： * @param
	 * @return java.util.List<java.util.Map>
	 */
	List<Map> searchAllCompanyUser(String lastDate,String now);
	List<User> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	UserSearchDto searchApproveUser(UserSearchDto dto);
	/**
	 * 根据用户名查找用户
	 * @param username
	 * @return
	 */
	User findByUsername(String username,String platform);
	/**
	 * 根据身份证查找用户
	 * @param idNum
	 * @return
	 */
	User findByIdNum(String idNum,String platform);
	/***
	 *  根据用户名查询
	 * @param username
	 * @return
	 */
	User findByUsernameForPolice(String username);

	/**
	 * 根据用户名和状态查找用户
	 * @param username
	 * @param active
	 * @return
	 */
	User findByUsernameStatus(String username,Boolean active);
	/**
	 * 修改用户
	 * @param user
	 */
	void saveOrUpdate(User user,String platform);

	/**
	 * 删除用户
	 * @param user
	 */
	void delete(User user);

	/**
	 * 更新密码
	 * @param user
	 */
	void updatePassword(User user);

	/**
	 * 更新密码公安机关
	 * @param user
	 */
	void updatePasswordBypolice(User user);

	/***
	 * 更新登陆状态
	 * @param user
	 */
	void updateLoginState(User user);

	UserSearchDto search(UserSearchDto dto);

	User findById(Long userid);

	/***
	 * 根据公司ID获取
	 * @param comId
	 * @return
	 */
	User findByComId(Long comId);

	User findByIdForManager(Long userid);

	void saveOrUpdateForDS(User user);


	List<User> findAll();

	void saveOrUpdateCompanyUser(User user,String platform);

	/**
	 * 保存公司用户修改（与saas对接）
	 * @param user
	 */
	void saveOrUpdateCompanyUserForSAAS(User user);

	/**
	 * 改变初始化状态
	 * @param user
	 */
	void updateInitstep(User user);

	void updateXjdUserId(User user);

	List<User> findXjdUserList();
	
	void updateFlag(User user);
	
	void updateAuthMark(User user);

	List<ReportData> findByAreaReport(ReportDataSearchDto searchDto);

	void autoExportUser();

	void saveOrUpdateForImport(User user);

	/**
	 * 根据号码查询用户
	 * @param phone
	 * @return
	 */
	User findByPhone(String phone);

	User findByUsernameAndPlatform(String username);

	Boolean checkRole(User currentUser, Object czjsid);

	/**
	 * 账号管理
	 * @param dto
	 * @param dto
	 * @return
	 * @throws Exception
	 */
	UserSearchDto searchAccount(UserSearchDto dto);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<User> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<User> list);

	/***
	 * 公安用户管理查询
	 * @param dto 查询条件参数
	 * @param ajaxPageResponse 返回数据对象
	 * @return 查询列表
	 */
    void searchForPage(UserPageSearchDto dto, AjaxPageResponse<PoliceUserDto> ajaxPageResponse);


	/***
	 * 更新云会议状态
	 * @param user
	 */
	void updateConferenceState(User user);

    void setDateView(User user);

	User findGSAndZRRByUsername(String username);
}
