package com.bcxin.ars.service;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SecurityCompanyInsuranceSearchDto;
import com.bcxin.ars.model.SecurityCompanyInsurance;

import java.util.List;

/**
 * 保安公司保险信息信息
 * @author Ethan
 */
public interface SecurityCompanyInsuranceService {


	/**
	 * 新增或更新保安公司保险信息信息
	 * @param securityCompanyInsurance
	 */
	void saveOrUpdate(SecurityCompanyInsurance securityCompanyInsurance);

	/**
	 * 根据ID获取保安公司保险信息信息
	 * @param id
	 * @return
	 */
	public SecurityCompanyInsurance findById(long id);

	/**
	 * 删除保安公司保险信息信息
	 * @param securityCompanyInsurance
	 * @return
	 */
	void delete(SecurityCompanyInsurance securityCompanyInsurance);

	/**
	 * 查询保安公司保险信息信息
	 * @param dto
	 * @return
	 */
	public SecurityCompanyInsuranceSearchDto search(SecurityCompanyInsuranceSearchDto dto);

	List<SecurityCompanyInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SecurityCompanyInsurance securityCompanyInsurance);

	List<SecurityCompanyInsurance> findByUserId(Long userId);
}
