package com.bcxin.ars.service;
import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;

/**
 * 保安处罚信息
 * @author Ethan
 */
public interface SbPunishService {


	/**
	 * 新增或更新保安处罚信息
	 * @param sbPunish
	 */
	void saveOrUpdate(SbPunish sbPunish);

	/**
	 * 根据ID获取保安处罚信息
	 * @param id
	 * @return
	 */
	public SbPunish findById(long id);

	/**
	 * 删除保安处罚信息
	 * @param sbPunish
	 * @return
	 */
	void delete(SbPunish sbPunish);

	/**
	 * 查询保安处罚信息
	 * @param dto
	 * @return
	 */
	public SbPunishSearchDto search(SbPunishSearchDto dto);

	List<SbPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbPunish sbPunish);


	/**
	 * 与saas对接
	 * 新增或更新保安处罚信息
	 * @param sbPunishList
	 */
    void saveOrUpdateForSAAS(List<SbPunish> sbPunishList);

	/**
	 * 与saas对接
	 * 根据saas主键查询
	 * @param id
	 */
	List<SbPunish> findByPenaltyId(Long id);

	/**
	 * 与saas对接 根据saas主键删除
	 * @param penaltyId
	 */
	void deleteByPenaltyId(Long penaltyId);
}
