package com.bcxin.ars.service;
import com.bcxin.ars.model.FilerecordOut;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 文件记录信息
 * @author Ethan
 */
public interface FilerecordOutService {


	/**
	 * 新增或更新文件记录信息
	 * @param filerecordOut
	 */
	void saveOrUpdate(FilerecordOut filerecordOut);

	/**
	 * 根据ID获取文件记录信息
	 * @param id
	 * @return
	 */
	public FilerecordOut findById(long id);

	/**
	 * 根据filepath获取文件记录信息
	 * @param filepath
	 * @return
	 */
	public FilerecordOut findByFilepath(String filepath);



	void save(FilerecordOut filerecordOut);

	/**
	 *
	 * @Decription:查询一段日期内同步文件记录
	 * @author：wjb
	 * @method  findFilerecordOutByTime
	 * @date：2018年9月14日10:31:08
	 * @param startDate
	 * @param endDate
	 * @return java.util.List<com.bcxin.ars.model.FilerecordOut>
	 */
	List<FilerecordOut> findFilerecordOutByTime(String startDate,String endDate);



}
