package com.bcxin.ars.service.sys;

import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.sys.ApprovalLog;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/04/08 0008.
 */
public interface ApprovalLogService {

    List<ApprovalLog> findByProcessInstanceId(String processInstanceId);

    List<ApprovalLog> findByApprovalId(String s);
    /**
     *
     * @Decription: 通过进程id查询打印信息
     * @author：zhongjianhui
     * @method  findPrintfMessageByApprovalId
     * @date：2018/8/9 10:49
     * @params： * @param processInstanceId
     * @return java.util.Map
     */
    Map findPrintfMessageByApprovalId(Map map);
    /**
     *
     * @Decription:查询一段日期内审批日志
     * @author：zhongjianhui
     * @method  findApprovalLogByTime
     * @date：2018/8/14 15:35
     * @params： * @param startDate
     * @param endDate
     * @return java.util.List<com.bcxin.ars.model.sys.ApprovalLog>
     */
    List<ApprovalLog> findApprovalLogByTime(String startDate,String endDate);
    /**
     *
     * @Decription:批量查询ID是否有在列表中
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018年8月15日 09:34:50
     * @params： * @param approvalLog
     * @return java.lang.Long
     */
    List<ApprovalLog> findByBatchId(List<ApprovalLog> approvalLogList);
    /**
     *
     * @Decription:批量插入日志
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018年8月15日 09:34:50
     * @params： * @param approvalLog
     * @return java.lang.Long
     */
    void importBatchLog(List<ApprovalLog> approvalLogList);

    /**
     *获取同步到外网的数据列表
     * @param startDate 开始日期
     */
    List<ApprovalLog> findDSOutList(String startDate);
}

