package com.bcxin.ars.service.sb;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.report.PersonPolicyDto;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

public interface YearreportdataService {

	Yearreportdata findByUserId(long userId);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/8/17 9:15
	 * @params： * @param approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Yearreportdata>
	 */
	List<Yearreportdata> findByBatchId(List<Approval> approvalList);

	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method  updateBatch
	 * @date：2018/8/17 9:24
	 * @params： * @param list
	 * @return void
	 */
	void updateBatch(List<Yearreportdata> list);
	public void saveOrUpdateDateForUserId(Yearreportdata yearreportdata);

	void saveOrUpdate(Yearreportdata yearreportdata);

	public PersonPolicyDto getPersonPolicyReportByCompanyId();

	Yearreportdata findById(Long businessid);

	List<Yearreportdata> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(Yearreportdata yearreport);

	Object queryYearReportList(YearReportsSearchDto searchDto);

	void updateOperator(Yearreportdata yearreportdata);

	void updateSealState(Long yearReportId, String sealState);

	YearReportsSearchDto search(YearReportsSearchDto searchDto);

	/**
	 * 查询用户信息发短信
	 * 
	 * @param businessid
	 * @return
	 */
	Yearreportdata findByIdForSendMessage(Long businessid);

	void sendMessage(Yearreportdata yearreportdata);

	void saveOrUpdateForApproval(Yearreportdata yearreport);

	/**
	 * 给为填写年报公司的法人发信息提示
	 */
	void sendMessageForLegalPerson(String userId);

	Boolean checkOnLinePolicy();

	Boolean checkInvestorInput();

	/***
	 * 更新指派民警ID
	 * 
	 * @param yearreportdata
	 */
	void updatePoliceId(Yearreportdata yearreportdata);

	PageResult queryTable(YearReportsSearchDto searchDto);

    void saveOrUpdateForApprovalImport(Yearreportdata yearreport);

    void edit(Yearreportdata yearreportdata);

    void searchForPage(YearReportsSearchDto dto, AjaxPageResponse<YearReportDto> page);
}