package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.LegalchangeSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface LegalchangeService {

    Legalchange findById(long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:15
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<Legalchange> findByBatchId(List<Approval> approvalList);
    /**
     *
     * @Decription:通过id查询处理签打印内容
     * @author：zhongjianhui
     * @method  searchForPrintf
     * @date：2018/10/12 17:08
     * @params： * @param id
     * @return java.util.Map
     */
    Map searchForPrintf(long id);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:24
     * @params： * @param list
     * @return void
     */
    void updateBatch(List<Legalchange> list);

    void saveOrUpdate(Legalchange legalchange);


    void saveOrUpdateForIntegrate(Legalchange legalchange, User currentUser);

    void saveOrUpdateForDS(Legalchange legalchange);

    LegalchangeSearchDto search(LegalchangeSearchDto dto);
    /***
     * 项目变更查询证书
     * @param dto
     * @return
     */
    LegalchangeSearchDto searchCompanyCertificate(LegalchangeSearchDto dto);

    void delete(Legalchange legalchange);

    Legalchange findByUser(Long userid);

    void updateAndSaveWorkExperience(Legalchange legalchange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post);

    List<Legalchange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<Legalchange> findAll();

    PageResult searchLegalchangeList_table(Map<Object, Object> p);

    public void updatePoliceId(Legalchange legalchange);

    void saveOrUpdateForApproval(Legalchange legalchange);

    void updateCensorStatus(Legalchange legalchange);

    List<Legalchange> findApprovePassByCompanyId(Long companyId);

    void saveOrUpdateForApprovalImport(Legalchange legalchange);

    void searchForPage(LegalchangeSearchDto dto, AjaxPageResponse<Legalchange> page);
}
