package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeClassPageSearchDto;
import com.bcxin.ars.dto.sb.GradeClassDto;
import com.bcxin.ars.model.sb.GradeClass;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
/****
 * 等级证班级信息
 * @author  subh
 */
public interface GradeClassService {
    /***
     * 等级证班级信息查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradeClass> query(GradeClassPageSearchDto dto, AjaxPageResponse<GradeClass> ajaxPageResponse);
    /**
     *获取同步到外网的数据列表
     * @param startDate 开始日期
     */
    List<GradeClass> findDSOutList(String startDate);


    /***
     * 根据ID查询详细
     * @param id
     * @return
     */
    GradeClass findById(Long id);
    /****
     * 批量获取根据ID
     * @param list
     * @return
     */
    List<GradeClass> findByBatchId(List<GradeClass> list);
    /***
     * 内网同步到外网批量方法
     * @param list
     */
    void importBatch(List<GradeClass> list);
    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param gradePractice
     */
    void saveOrUpdateForDS(GradeClass gradePractice);
    /**
     * 查询需要生成同步文件的等级证班级信息
     * @param dto
     * @return
     */
    List<GradeClass> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 更新数据
     * @param dto
     */
    void saveOrUpdate(GradeClassDto dto);
    /**
     * 取消班级
     * @param dto
     */
    void updateCancelClass(GradeClassDto dto);
    /**
     * 更新数据
     * @param dto
     */
    void updateClassPersonInfo(GradeClassDto dto);
    /**
     * 自动更新审批状态
     */
    void autoUpdateApprovalState(String hour);

    /***
     * 保存审批结果
     * @param gradeClass
     */
    void saveAppealApproval(GradeClass gradeClass);

    /**
     * 第三方培训平台增加等级证开班申请接口
     *
     * @param gradeClassInfo 等级证开班申请信息
     * @return 成功/失败
     */
    AjaxResult addGradeClassRequest(String gradeClassInfo);

    /**
     * 第三方培训平台五级等级证开班申请状态查询
     *
     * @param gradeClassName 开班名称
     * @return 审核通过/审核不通过
     */
    AjaxResult getGradeClassRequestResult(String gradeClassName);

    /**
     * 添加班级成员
     *
     * @param gradeClass 等级证班级
     * @return 成功/失败
     */
    AjaxResult addGradeClassPerson(String gradeClass);

    /**
     * 删除班级成员
     *
     * @param gradeClass 等级证班级
     * @return 成功/失败
     */
    AjaxResult removeGradeClassPerson(String gradeClass);

    /**
     * 五级等级证开班申请补充信息
     *
     * @param gradeClass 等级证实操培训签到表、公安督导检查表
     * @return 成功/失败
     */
    AjaxResult commitGradeClassAdditionalInfo(String gradeClass);

    /**
     * 五级等级证开班成绩确认
     *
     * @param gradeResult 开班成绩
     * @return 成功/失败
     */
    AjaxResult confirmGradeResult(String gradeResult);
}
