package com.bcxin.ars.service.gx;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gx.RequestDto;
import com.bcxin.ars.model.gx.InternetPlusBusiness;

import java.util.List;


/**
 * 广西一体化申报请求数据Service接口
 * 
 * @author lin
 * @date 2022-04-13
 */
public interface InternetPlusBusinessService {
    /****
     * 删除
     * @param internetPlusBusiness
     * @return
     */
    int delete(InternetPlusBusiness internetPlusBusiness);

    /****
     * 保存
     * @param internetPlusBusiness
     * @return
     */
    int save(InternetPlusBusiness internetPlusBusiness);

    /****
     * 选择性修改
     * @param internetPlusBusiness
     * @return
     */
    void updateSelective(InternetPlusBusiness internetPlusBusiness);

    /****
     * 主键查询
     * @param id
     * @return
     */
    InternetPlusBusiness findById(Long id);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<InternetPlusBusiness> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<InternetPlusBusiness> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<InternetPlusBusiness> findByBatchId(List<InternetPlusBusiness> list);


    AjaxResult saveCertificateVerification(RequestDto requestDto);

    AjaxResult saveLegalchange(RequestDto requestDto);

    AjaxResult saveSponsorlicense(RequestDto requestDto);
}
