package com.bcxin.ars.service;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGoodThingDetailDTO;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityGoodThing;
import com.bcxin.ars.model.sb.GradePractice;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 *保安员好人好事要闻服务类
 */
public interface SecurityGoodThingService {

    void save(SecurityGoodThing securityGoodThing);

    public List<SecurityGoodThing> findByUserid(Long userid);

    public SecurityGoodThing findById(Long id);

    public SecurityGoodThingDto search(SecurityGoodThingDto dto);

    public AjaxResult searchGoodThing(SecurityGoodThingDto dto);

    public SecurityGoodThing updateById(SecurityGoodThing securityGoodThing);

    public AjaxResult deleteGoodThing(long id);

    public AjaxResult deleteAllGoodThing();

	List<SecurityGoodThing> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SecurityGoodThing securityGoodThing);

    SecurityGoodThingDetailDTO findByIdForPerson(Long id);

    void exportSecurityGoodThing(List<SecurityGoodThing> data, File file);

    /**
     * 查询好人好事 wjb 2018年11月13日13:35:59
     * @param p
     * @return
     */
    PageResult searchSecuritygoodthingList_table(Map<Object, Object> p);

    /**
     * 与saas对接 根据saas主键删除
     * @param goodDeedsId
     * @return
     */
    void deleteGoodThingByGoodDeedsId(Long goodDeedsId);

    /**
     * 与saas对接  新增或修改好人好事信息
     * @param securityGoodThing
     */
    void saveOrUpdateForSAAS(SecurityGoodThing securityGoodThing);

    /**
     * 与saas对接  根据goodDeedsId查找
     * @param goodDeedsId
     */
    SecurityGoodThing findByGoodDeedsId(Long goodDeedsId);


    /***
     * 查询好人好事
     * @param dto 查询条件参数
     * @return 查询列表
     */
    List<SecurityGoodThing> query(SecurityGoodThingDto dto, AjaxPageResponse<SecurityGoodThing> ajaxPageResponse);
}
