package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;

public interface SecurityCompanyPersonService {
	
	Long save(SecurityCompanyPerson companyPerson);


	void delete(SecurityCompanyPerson companyPerson);
	
	SecurityCompanyPerson findByPerson(SecurityPerson person);

    SecurityCompanyPerson findSingleByPerson(SecurityPerson person);

    List<SecurityCompanyPerson> findByRoleId(Long roleId);
	
	List<SecurityCompanyPerson> findByOrgId(Long orgId);

	void update(SecurityCompanyPerson companyPerson);

    void saveBatch(List<SecurityCompanyPerson> list);

    public void saveOrUpdateForDS(SecurityCompanyPerson companyPerson);

	List<SecurityCompanyPerson> searchForDataSynchronization( DataSynchronizationSearchDto searchDto);

	SecurityCompanyPerson findByPersonAndCompany(Long personId, Long companyId);

    void deleteByPersonId(Long id);

	/***
	 * 根据ID获取
	 * @param Id
	 * @return
	 */
	SecurityCompanyPerson findById(Long Id);
}
