package com.bcxin.ars.service;
import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessManagementSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.SbBusinessOutsideManagement;

/**
 * 跨区经营信息管理
 * @author Ethan
 */
public interface SbBusinessManagementService {


	/**
	 * 新增或更新跨区经营信息
	 * @param sbBusinessManagement
	 */
	void saveOrUpdate(SbBusinessManagement sbBusinessManagement);

	/**
	 * 根据ID获取跨区经营信息
	 * @param id
	 * @return
	 */
	public SbBusinessManagement findById(long id);

	/**
	 * 删除跨区经营信息
	 * @param sbBusinessManagement
	 * @return
	 */
	void delete(SbBusinessManagement sbBusinessManagement);

	/**
	 * 查询跨区经营管理信息
	 * @param dto
	 * @return
	 */
	public SbBusinessManagementSearchDto search(SbBusinessManagementSearchDto dto);

	List<SbBusinessManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbBusinessManagement sbBusinessManagement);


}
