package com.bcxin.ars.rest.task;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.service.task.ComContractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 合同
 * @author linqinglin
 * @date 2019/10/12 0012 17:43
 */
@Controller
@RequestMapping("comContract")
public class ComContractController {

    private Logger logger = LoggerFactory.getLogger(ComContractController.class);

    @Autowired
    private ComContractService comContractService;


    /**
     *保存合同
     * @param comContract
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(ComContract comContract){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setMsg("保存成功");
            comContractService.save(comContract);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }
}
