package com.bcxin.ars.rest.sb;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.service.sb.YearreportdataService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


import java.util.Date;

@Controller
@RequestMapping("yearreportdata")
public class YearreportdataController {

    private Logger logger = LoggerFactory.getLogger(YearreportdataController.class);

    @Autowired
    private YearreportdataService yearreportdataService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
    /**
     * 根据用户ID获取
     * @return
     */
    @RequestMapping("findByUserId")
    public @ResponseBody
    AjaxResult findByUserId() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
          User user = arsUtil.getCurrentUser();
            try {
                //如果用户不存在则抛出异常 add start 2018-06-09 subh
                if(user==null){
                    throw new ArsException("用户不存在！！");
                }

                //企业年报提醒
                Config yearReportRemindConfig =configUtils.getConfigByKey(Constants.YEAR_REPORT_REMIND);
                if (yearReportRemindConfig != null && Constants.YEAR_REPORT_REMIND_YES.equals(yearReportRemindConfig.getValue())) {
                    Config remindTime = configUtils.getConfigByKey(Constants.YEAR_REPORT_REMIND_ENDTIME);
                    if(remindTime != null) {
                        Date remindDate = DateUtil.convertStringToDate(remindTime.getValue());
                        if (remindDate.getTime() <= System.currentTimeMillis()) {
                            result.setSuccessful(false);
                            return result;
                        }
                    }
                    Yearreportdata yearreportdata = yearreportdataService.findByUserId(user.getId());
                    result.setSuccessful(true);
                    result.setData(yearreportdata);
                }else{
                    result.setData(null);
                }
            } catch(Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
