package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.bcxin.ars.service.sb.PerCheckRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

/**
 * 对外接口
 *
 * @author zhangyutong
 */
@Controller
@RequestMapping("checkRecord")
public class PerCheckRecordController {

    private static final Logger logger = LoggerFactory.getLogger(PerCheckRecordController.class);

    @Resource
    private PerCheckRecordService perCheckRecordService;

    /**
     * 保存
     *
     * @param perCheckRecord 表单信息
     * @return 成功结果
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(PerCheckRecord perCheckRecord) {
        AjaxResult result = new AjaxResult();
        try {
            perCheckRecordService.save(perCheckRecord);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }
}
