package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.util.DES3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;


/**
 * 保安员等级证报名结业证书控制器
 *
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
@Controller
@RequestMapping("gradeCompleteCer")
public class GradeCompleteCerController {

    Logger logger = LoggerFactory.getLogger(GradeCompleteCerController.class);

    @Autowired
    GradeCompleteCerService gradeCompleteCerService;

    @Autowired
    PersonGradeService personGradeService;


    /**
     * 根据报名id查询结业证书详情
     * @param personGradeId
     * @return
     */
    @RequestMapping("findByPersonGradeId")
    @ResponseBody
    @Deprecated
    public AjaxResult findByPersonGradeId(String personGradeId, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //允许跨域访问
            response.setHeader("Access-Control-Allow-Origin", "*");
            //生成二维码的时候用URLDecoder.encode加密，所以这里要decode解密
            personGradeId = personGradeId.replaceAll(" ","+");
//            personGradeId = URLDecoder.decode(personGradeId, "utf-8");
            //生成二维码的时候用DES3.encode加密，所以这里要decode解密
            personGradeId = DES3.decode(personGradeId);
            result.setSuccessful(true);
            result.setData(gradeCompleteCerService.findByPersonGradeIdWithQRCode(Long.parseLong(personGradeId)));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}

