package com.bcxin.ars.rest.app;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AppNoticeSearchDto;
import com.bcxin.ars.model.task.AppNoticeType;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.task.AppNoticeService;
import com.bcxin.ars.service.task.AppNoticeTypeService;

/**
 * 消息通知功能
 * @author zhangye
 * @version 1.0.9
 */
@Controller
@RequestMapping("app/notice")
public class AppNoticeController {
	
	private static final Logger logger = LoggerFactory.getLogger(AppNoticeController.class);
	
	@Autowired
	private AppNoticeTypeService appNoticeTypeService;
	
	
	@Autowired
	private AppNoticeService appNoticeService;
	
	 
 
	/**
	 * 通过保安人员ID获取通知分类列表
	 * @param personId 保安人员ID
	 * @return
	 */
	@RequestMapping("v-1-0-9/type/findappnoticetypelist/{personId}")
	public @ResponseBody AppAjaxResult findAppNoticeTypeList(@PathVariable("personId")Long personId) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			if(personId == null){
				errMsg = "保安人员ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			AppNoticeType appNoticeType = new AppNoticeType();
			appNoticeType.setPersonId(personId);
			List<AppNoticeType> data = appNoticeTypeService.findAppNoticeTypeList(appNoticeType);
			result.setSuccessful(true);
			result.setEncodeData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	 
	/**
	 * 获取消息通知列表
	 * @param appResult
	 * @return
	 */
	@RequestMapping("v-1-0-9/findappnoticelist")
	public @ResponseBody AppAjaxResult findAppNoticeList(AppAjaxResult appResult) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			AppNoticeSearchDto appNoticeSearchDto = appResult.getDecodeData(AppNoticeSearchDto.class);
			String errMsg = "";
			if(appNoticeSearchDto == null){
				errMsg = "消息通知参数不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			if(appNoticeSearchDto.getNoticeTypeID() == null){
				errMsg = "消息通知分类ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			if(appNoticeSearchDto.getPersonId() == null){
				errMsg = "保安人员ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			AppNoticeSearchDto  resultdto =  appNoticeService.findAppNoticeList(appNoticeSearchDto);
 
			AppNoticeSearchDto searchDto = new AppNoticeSearchDto();
			searchDto.setData(resultdto.getData());
			searchDto.setTotalCount(resultdto.getTotalCount());
			searchDto.setPageNum(resultdto.getPageNum());
			searchDto.setNumPerPage(resultdto.getNumPerPage());
			result.setSuccessful(true);
			result.setEncodeData(searchDto);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 设置消息通知为已读
	 * @param appResult
	 * @return
	 */
	@RequestMapping("v-1-0-9/updatereadstatus/{id}")
	public @ResponseBody AppAjaxResult updateReadStatus(@PathVariable("id")Long id) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			String errMsg = "";
			if(id == null){
				errMsg = "消息通知ID不能为空";
				result.setSuccessful(false);
				result.setMsg(errMsg);
				return result;
			}
			appNoticeService.updateReadStatus(id);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	 
}
