package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.SecurityConfesscompany;
import com.bcxin.ars.service.SecurityConfesscompanyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;


@Controller
@RequestMapping("securityConfesscompany")
public class SecurityConfesscompanyController {
	
	private static final Logger logger = LoggerFactory.getLogger(SecurityConfesscompanyController.class);
	
	@Autowired
	private SecurityConfesscompanyService securityConfesscompanyService;

	/**
	 * 创建或更新保安培训机构信息
	 * @param securityConfesscompany 保安培训机构信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(@Valid  SecurityConfesscompany securityConfesscompany, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			securityConfesscompanyService.saveOrUpdate(securityConfesscompany);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安培训机构信息
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityConfesscompany securityConfesscompany = securityConfesscompanyService.findById(id);

			if(securityConfesscompany != null) {
				securityConfesscompanyService.delete(securityConfesscompany);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
