package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.PerBlackListDto;
import com.bcxin.ars.service.PersonBlackListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import java.util.Date;
import java.util.List;

/**
 * 保安行业黑名单 控制层
 * @author yyx
 * @date 2020/05/09 0013 11:12
 */
@Controller
@RequestMapping("personBlackList")
public class PersonBlackListController {
    private static final Logger logger = LoggerFactory.getLogger(PersonBlackListController.class);
    @Autowired
    private PersonBlackListService personBlackListService;
    @RequestMapping("findBlackPersonList")
    public @ResponseBody AjaxResult findBlackPersonList(Date startTime,Date endTime){
        AjaxResult result = new AjaxResult();
        try{
            List<PerBlackListDto> personBlackLists = personBlackListService.findBlackPersonList(startTime,endTime);
            if(personBlackLists!=null){
                result.setData(personBlackLists);
                result.setSuccessful(true);
            }else {
                result.setSuccessful(false);
                result.setMsg("暂无查询到保安行业黑名单人员");
            }
        }
        catch (Exception e){
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }
}
