package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 广西公安厅互联网+平台对接 设立保安培训机构审批申报
 * @author subh
 * @since jdk1.8
 * @see TraincompanyapplyService#saveOrUpdate
 * @see ArsUtil#getCurrentUser
 */
@Controller
@RequestMapping("traincompanyapply")
public class TraincompanyapplyController {

    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(TraincompanyapplyController.class);
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    @Autowired
    private ArsUtil arsUtil;
    /**
     * 设立保安培训机构审批申报新增或更新
     * @param traincompanyapply  设立保安培训机构审批申报数据
     * @return 返回执行结果对象
     * @throws Exception  系统异常
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody AjaxResult saveOrUpdate(Traincompanyapply traincompanyapply) throws Exception{
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                traincompanyapplyService.saveOrUpdate(traincompanyapply);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
