package com.bcxin.ars.rest.manage;

import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.rest.util.manage.ManageResultUtil;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.gx.CerPermitService;
import com.bcxin.ars.service.sx.DataPushService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.*;
import com.bcxin.ars.timer.approval.AutoApprovalProcess;
import com.bcxin.ars.timer.bdgk.BdgkServiceJob;
import com.bcxin.ars.timer.company.InvestorInfoIncompleteNotifyService;
import com.bcxin.ars.timer.company.ManagerInfoIncompleteNotifyService;
import com.bcxin.ars.timer.conference.UpdateConferenceStateService;
import com.bcxin.ars.timer.dataSync.*;
import com.bcxin.ars.timer.gradePerson.AutoGradePersonCensorStatus;
import com.bcxin.ars.timer.gradeclass.AutoGradeClass;
import com.bcxin.ars.timer.ministerial.MinisterialAutoService;
import com.bcxin.ars.timer.person.AutoGetPersonBaseInfo;
import com.bcxin.ars.timer.person.AutoPersonBaseInfoBlob;
import com.bcxin.ars.timer.person.UpdateCompanyPerNumService;
import com.bcxin.ars.timer.personAdapt.PersonAdaptCensorStatusService;
import com.bcxin.ars.timer.personGrade.PersonGradeCensorStatusService;
import com.bcxin.ars.timer.personcertificate.*;
import com.bcxin.ars.timer.police.*;
import com.bcxin.ars.timer.problemPerson.ManageInfoProblemServiceJob;
import com.bcxin.ars.timer.problemPerson.ProblemPersonCriminalServiceJob;
import com.bcxin.ars.timer.problemPerson.ProblemPersonReScreenServiceJob;
import com.bcxin.ars.timer.problemPerson.ProblemPersonServiceJob;
import com.bcxin.ars.timer.report.IndexReportService;
import com.bcxin.ars.timer.task.ComTaskStatusService;
import com.bcxin.ars.timer.task.status.AutoUpdateStatusServiceV2;
import com.bcxin.ars.timer.task.status.CrossCompanyFilingExpiredNotifyService;
import com.bcxin.ars.util.Constants;
import com.bcxin.zw.dao.BazwDao;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

/**
 * 定时任务
 * @author linqinglin
 * @date 2019/01/11 0011 14:56
 */
@Controller
@RequestMapping("manage/task")
public class ManageTaskController {

    /***
     * 日志
     */
    private static final  Logger logger = LoggerFactory.getLogger(ManageTaskController.class);
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;
    @Autowired
    private DataSyncDSService dataSyncDSService;

    @Autowired
    private AutoUpdateFingerprint autoUpdateFingerprint;

    @Autowired
    private AutoGradeClass autoGradeClass;
    @Autowired
    private UpdateCompanyPerNumService updateCompanyPerNumService;

    @Autowired
    private CerPermitService cerPermitService;
    @Autowired
    private ApprovalSynchronizationService approvalSynchronizationService;

    @Autowired
    private AutoUpdateCensorStatus autoUpdateCensorStatus;


    @Autowired
    private GradeCertificateToSAASService getGradeCertificateToSAASService;

    @Autowired
    private DataSyncInToOutService dataSyncInToOutService;
    @Autowired
    private AutoUpdateCensorStatusForOldData autoUpdateCensorStatusForOldData;

    @Autowired
    private ProblemPersonServiceJob problemPersonServiceJob;

    @Autowired
    private ProblemPersonCriminalJob problemPersonCriminalJob;

    @Autowired
    private ProblemPersonCriminalServiceJob problemPersonCriminalServiceJob;

    @Autowired
    private ProblemPersonReScreenServiceJob problemPersonReScreenServiceJob;

    @Autowired
    private AutoApprovalProcess autoApprovalProcess;


    @Autowired
    private AutoGradePersonCensorStatus autoGradePersonCensorStatus;
    @Autowired
    private AutoGetPersonBaseInfo autoGetPersonBaseInfo;

    @Autowired
    private DataSyncInToOutAuthService dataSyncInToOutAuthService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private BazwDao bazwDao;

    @Autowired
    private GradeCertificateToSAASService gradeCertificateToSAASService;

    @Autowired
    private DataPushService dataPushService;

    @Autowired
    private IndexReportService indexReportService;

    @Autowired
    private UpdateConferenceStateService updateConferenceStateService;

    @Autowired
    private PersonGradeCensorStatusService PersonGradeCensorStatusService;

    @Autowired
    private ComTaskStatusService comTaskStatusService;

    @Autowired
    private PersonAdaptCensorStatusService personAdaptCensorStatusService;

    @Autowired
    private DataSyncDSOneMonthService dataSyncDSOneMonthService;
    @Autowired
    private AutoUpdateStatusServiceV2 autoUpdateStatusServiceV2;
    @Autowired
    private AutoPersonBaseInfoBlob autoPersonBaseInfoBlob;

    @Autowired
    private AutoCancellationProjectNoService autoCancellationProjectNoService;

    @Autowired
    private BdgkServiceJob bdgkServiceJob;

    @Autowired
    private BankAccountToSaasService bankAccountToSaasService;

    @Autowired
    private SecurityCertificateToSaasService securityCertificateToSaasService;

    @Autowired
    private InterfaceFailReCallService interfaceFailReCallService;

    @Autowired
    private ThreeCerToGovService threeCerToGovService;

    @Autowired
    private PushToAppraiseService pushToAppraiseService;

    @Autowired
    private DataSyncFileService dataSyncFileService;

    @Autowired
    private DataSyncToFtpService dataSyncToFtpService;

    @Autowired
    private DataSyncAlarmService dataSyncAlarmService;

    @Autowired
    private PersonImgToPersonBaseInfoService personImgToPersonBaseInfoService;

    @Autowired
    private DataSyncI2OService dataSyncI2OService;

    @Autowired
    private DataSyncO2IService dataSyncO2IService;

    @Autowired
    private CrossCompanyFilingExpiredNotifyService crossCompanyFilingExpiredNotifyService;

    @Autowired
    private PersonCerPhotoService personCerPhotoService;

    @Autowired
    private InvestorInfoIncompleteNotifyService investorInfoIncompleteNotifyService;

    @Autowired
    private ManagerInfoIncompleteNotifyService managerInfoIncompleteNotifyService;

    @Autowired
    private MinisterialAutoService ministerialAutoService;

    @Autowired
    private ManageInfoProblemServiceJob manageInfoProblemServiceJob;

    @Autowired
    private ProblemPersonJob problemPersonJob;

    @Autowired
    private ProblemPersonReScreenJob problemPersonReScreenJob;

    @Autowired
    private CerPhotoJob cerPhotoJob;

    @Autowired
    private PersonCensorJob personCensorJob;

    @Autowired
    private AutoPushToIntegratedService autoPushToIntegratedService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    /**
     * 定时任务列表页面
     * @return
     */
    @RequestMapping("init")
    public ModelAndView approvalInit() {
        ModelAndView view = new ModelAndView("/manage/task/manageList");
        view.addObject("DATASYNC_SWITCH",configUtils.getValueByKey(Constants.DATASYNC_SWITCH));
        return view;
    }

    /**
     * 手动任务列表页面
     * @return
     */
    @RequestMapping("manual/page/init")
    public ModelAndView manualInit() {
        ModelAndView view = new ModelAndView("/manage/task/manualList");
        return view;
    }

    /**
     * 手动运行定时任务
     * @param type
     * @return
     */
    @RequestMapping("manual/{type}")
    @ResponseBody
    public JSONObject manual(@PathVariable String type) {
        try {
            Config config = configUtils.getConfigByKey("approvalflag");
                new Thread(()->{
                    switch (type){
                        case "1":
                            dataSyncDSService.run();
                            break;
                        case "2":
                            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                                personCerPhotoService.run();
                            }else{
                                cerPhotoJob.run();
                            }
                            break;
                        case "3":
                            autoUpdateFingerprint.autoUpdateFingerprintMethod();
                            break;
                        case "4":
                            approvalSynchronizationService.runApproval();
                            break;
                        case "5":
                            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                                autoUpdateCensorStatus.autoUpdateCensorStatusMethod();
                            }else{
                                personCensorJob.run();
                            }
                            break;
                        case "6":
                            autoUpdateCensorStatusForOldData.run();
                            break;
                        case "7":
                            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                                problemPersonServiceJob.run();
                            }else{
                                problemPersonJob.run();
                            }
                            break;
                        case "28":
                            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                                problemPersonReScreenServiceJob.run();
                            }else{
                                problemPersonReScreenJob.run();
                            }
                            break;
                        case "8":
                            autoApprovalProcess.run();
                            break;
                        case "9":
                            autoGetPersonBaseInfo.run();
                            break;
                        case "10":
                            autoGradePersonCensorStatus.run();
                            break;
                        case "11":
                            dataSyncInToOutService.run();
                            break;
                        case "12":
                            dataSyncInToOutAuthService.run();
                            break;
                        case "13":
                            List<Sponsorlicense> list = sponsorlicenseDao.findForSX();
                            for (Sponsorlicense p:
                                    list) {
                                dataPushService.send(p);
                            }
                           /* int i = 0;
                            int start = 1;*/
//                            List<SxItems> list = null;
//                            do{
//                                list =  dataPushService.query((i+1)*5000,start);
//                                dataPushService.save(list);
//                                start = (i+1)*5000+1;
//                                i++;
//                                System.out.println("i="+i+"----start"+start);
//                            }while (list.size()>0);

                           /* i = 0;
                            start = 1;
                            List<sxff> list2 = null;
                            do{
                                list2 =  dataPushService.querysxff((i+1)*5000,start);
                                dataPushService.savesxff(list2);
                                start= (i+1)*5000+1;
                                i++;
                                System.out.println("i="+i+"----start"+start);
                            }while (list2.size()>0);
*/
                            break;
                        case "14":
                            gradeCertificateToSAASService.sendToSAAS();
                            break;
                        case "15":
                            indexReportService.generateReport();
                            break;
                        case "16":
                            updateConferenceStateService.autoUpdateConferenceState();
                            break;
                        case "17":
                            autoGradeClass.run();
                            break;
                        case "18":
                            PersonGradeCensorStatusService.run();
                            break;
                        case "19":
                            comTaskStatusService.autoUpdateTaskStatus();
                            break;
                        case "20":
                            personAdaptCensorStatusService.run();
                            break;
                        case "21":
                            dataSyncDSOneMonthService.run();
                            break;
                        case "22":
                            autoUpdateStatusServiceV2.updateStatus();
                            break;
                        case "23":
                            updateCompanyPerNumService.run();
                            break;
                        case "24":
                            cerPermitService.send1();
                            cerPermitService.send();
                            break;
                        case "25":
                            autoPersonBaseInfoBlob.run();
                            break;
                        case "26":
                            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
                                problemPersonCriminalServiceJob.run();
                            }else{
                                problemPersonCriminalJob.run();
                            }
                            break;
                        case "27":
                            getGradeCertificateToSAASService.sendToSAAS();
                            break;
                        case "29":
                            bdgkServiceJob.run();
                            break;
                        case "30":
                            bankAccountToSaasService.sendToSaas();
                            break;
                        case "31":
                            securityCertificateToSaasService.sendToSaas();
                            break;
                        case "32":
                            interfaceFailReCallService.recall();
                        case "33":
                            threeCerToGovService.sendToGov();
                            break;
                        case "34":
                            pushToAppraiseService.reShareApprInfo();
                            break;
                        case "35":
                            dataSyncFileService.run();
                            break;
                        case "36":
                            dataSyncToFtpService.run();
                            break;
                        case "37":
                            dataSyncAlarmService.run();
                        case "38":
                            personImgToPersonBaseInfoService.run();
                            break;
                        case "39":
                            dataSyncO2IService.run();
                            break;
                        case "40":
                            dataSyncI2OService.run();
                        case "41":
                            crossCompanyFilingExpiredNotifyService.run();
                            break;
                        case "42":
                            investorInfoIncompleteNotifyService.run();
                            managerInfoIncompleteNotifyService.run();
                            break;
                        case "43":
                            ministerialAutoService.run();
                            break;
                        case "44":
                            manageInfoProblemServiceJob.run();
                            break;
                        case "45":
                            autoPushToIntegratedService.run();
                        case "46":
                            if(!configUtils.isIntranet()) {
                                securityCompanyService.resetCompanyCode();
                            }
                            break;
                        case "47":
                            if(!configUtils.isIntranet()&&Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                                autoCancellationProjectNoService.run();
                            }
                            break;
                        default:
                            break;
                    }
                }).start();
            return ManageResultUtil.returnSuccessJson("后台运行中","taskList","", "");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return ManageResultUtil.returnFailedJson("操作失败","taskList", "closeCurrent", "");
        }
    }
}

