package com.bcxin.ars.rest;

import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("securityCertificate/security")
public class SecurityCertificateController {

    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;
    /**
     * 修改为代推送
     * @param idnum
     * @return
     */
    @RequestMapping("authorization/{idnum}")
    @ResponseBody
    public AjaxResult authorization(@PathVariable String idnum) {
        AjaxResult result = new AjaxResult();

        SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(idnum);

        if(null!=securityCertificate){
            if(StringUtil.isEmpty(securityCertificate.getHeadImg())){
                PersonBaseInfo baseInfo = personBaseInfoDao.findByIdNum(idnum);
                if(null!=baseInfo &&StringUtil.isNotEmpty(baseInfo.getImgPath())){
                    securityCertificateDao.updateHeadImg(idnum,baseInfo.getImgPath());
                }else {
                    SecurityPerson person = securityPersonDao.findByIdCard(idnum);
                    if(null!=person&&StringUtil.isNotEmpty(person.getIdPhoto())){
                        securityCertificateDao.updateHeadImg(idnum,person.getIdPhoto());
                    }else {
                        result.setMsg("授权失败,无照片");
                        result.setSuccessful(false);
                        return result;
                    }
                }

            }
            int i = securityCertificateDao.updateIisDrawByIdNum(idnum, Constants.ISDRAW_WAITPASH);
            result.setSuccessful(true);
            result.setData(null);
        }else {
            result.setMsg("授权失败,证书无效或不存在");
            result.setSuccessful(false);
        }
        return result;
    }

}
