package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskSchedule;

/**
 * 任务排班数据类
 * @author Ethan
 */
public interface TaskScheduleDao {

	/**
	 * 新增任务排班
	 * @param taskSchedule
	 * @return
	 */
	Long save(TaskSchedule taskSchedule);
	
	/**
	 * 清空指定任务下的排班列表
	 * @param task
	 */
	void deleteByTask(Task task);
	
	/**
	 * 获取指定任务下指定排班列表
	 * @param task
	 * @return
	 */
	List<TaskSchedule> findByTaskId(Long taskId);

	List<TaskSchedule> searchForDataSynchronization(DataSynchronizationSearchDto dto);
}
