package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.page.ThirdPartyPageSearchDto;
import com.bcxin.ars.model.sys.ThirdParty;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 *第三方对接信息Dao
 * @author linqinglin
 * @Date 2020-05-15 10:14:15
 */
public interface ThirdPartyDao {

   /****
     * 删除
     * @param thirdParty
     * @return
     */
    int delete(ThirdParty thirdParty);

    /****
     * 保存
     * @param thirdParty
     * @return
     */
    int save(ThirdParty thirdParty);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ThirdParty findById(Long id);

    /****
     * clientId查询
     * @param clientId
     * @return
     */
    ThirdParty findByClientId(String clientId);

    /****
     * 修改
     * @param thirdParty
     * @return
     */
    int update(ThirdParty thirdParty);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ThirdParty> searchForPage(ThirdPartyPageSearchDto searchDto, AjaxPageResponse<ThirdParty> page);

}
