package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.sys.ExportColumnDto;
import com.bcxin.ars.model.sys.ExportColumn;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 导出配置数据层
 */
public interface ExportConfigColumnDao {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    ExportColumn findById(Long id);

    ExportColumn findByIdWithOutCache(Long id);
    /**
     * 分页查询
     * @param exportColumnDto
     * @param page
     */
    List<ExportColumn> search(ExportColumnDto exportColumnDto, AjaxPageResponse<ExportColumn> page);
    /***
     * 保存
     * @param exportColumn
     */
    void save(ExportColumn exportColumn);

    /**
     * 根据configId查询字段配置
     * @param configId
     * @return
     */
    List<ExportColumn> selectByConfigId(Long configId);
}
