package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.LegalchangeSearchDto;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface LegalchangeDao {

    Legalchange findById(Long id);

    Legalchange findByIdWithOutCache(Long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<Legalchange> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    List<Legalchange> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);

    /**
     *
     * @Decription:通过id查询处理签打印内容
     * @author：zhongjianhui
     * @method  searchForPrintf
     * @date：2018/10/12 17:08
     * @params： * @param id
     * @return java.util.Map
     */
    Map searchForPrintf(long id);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList")List<Legalchange> approvalList);

    Long save(Legalchange legalchange);

    void update(Legalchange legalchange);

    List<Legalchange> search(LegalchangeSearchDto dto);


    /***
     * 项目变更证书查询
     * @param dto
     * @return
     */
    List<Legalchange> searchCompanyCertificate(LegalchangeSearchDto dto);
    /***
     * 项目变更证书查询（个数）
     * @param dto
     * @return
     */
    Long searchCompanyCertificateCount(LegalchangeSearchDto dto);

    Long searchCount(LegalchangeSearchDto dto);

    void delete(Legalchange legalchange);

    Legalchange findByUser(Long userid);

    List<Legalchange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<Legalchange> findAll();

    int countLegalchangeList(Map<Object, Object> p);

    List<Map<Object,Object>> searchLegalchangeList(Map<Object, Object> p);

    List<Legalchange> findApproveByUserId(Long userId);

    List<Legalchange> findApprovePassByCompanyId(Long companyId);

    List<Map<Object,Object>> searchForPage(LegalchangeSearchDto dto, AjaxPageResponse<Legalchange> page);

    List<Legalchange> findUnIntegrated();
}
