package com.bcxin.ars.dao.gx;

import com.bcxin.ars.dto.gx.IntegratedApplyDto;
import java.util.List;

/**
 * 广西公安互联网+平台推送流水号到业务办理系统数据层
 * @author subh
 * @since jdk1.8
 * @see IntegratedApplyDto
 */
public interface IntegratedDao {
    /**
     * 广西公安互联网+平台推送流水号到业务办理系统新增
     * @param dto  一体化流水号表单数据
     * @return 无
     * @throws Exception  系统异常
     */
    void save(IntegratedApplyDto dto);
    /**
     * 根据参数查询一体化流水号查询列表
     * @param dto  一体化流水号查询参数
     * @return 查询结果列表
     * @throws Exception  系统异常
     */
    List query(IntegratedApplyDto dto);
}
