package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.dto.page.PerCerSnapshotPageSearchDto;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *保安员资格证打印快照Dao
 * @author linqinglin
 * @Date 2020-04-16 16:39:19
 */
public interface PerCerSnapshotDao {

   /****
     * 删除
     * @param perCerSnapshot
     * @return
     */
    int delete(PerCerSnapshot perCerSnapshot);

    /****
     * 保存
     * @param perCerSnapshot
     * @return
     */
    int save(PerCerSnapshot perCerSnapshot);

    /****
     * 新增
     * @param perCerSnapshot
     * @return
     */
    int insert(PerCerSnapshot perCerSnapshot);

    /****
     * 选择性插入
     * @param perCerSnapshot
     * @return
     */
    int insertSelective(PerCerSnapshot perCerSnapshot);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerCerSnapshot findById(Long id);

    /****
     * 修改
     * @param perCerSnapshot
     * @return
     */
    int update(PerCerSnapshot perCerSnapshot);

    /****
     * 选择修改
     * @param perCerSnapshot
     * @return
     */
    int updateSelective(PerCerSnapshot perCerSnapshot);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<PerCerSnapshot> searchForPage(PerCerSnapshotPageSearchDto searchDto, AjaxPageResponse<PerCerSnapshot> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PerCerSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PerCerSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PerCerSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerCerSnapshot> findByBatchId(@Param("list") List<PerCerSnapshot> list);

    void updateByCer(SecurityCertificate securityCertificate);
}
