package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/***
 * 等级证信息数据层
 * @author subh
 */
public interface GradeCertificateDao {
    /***
     * 培训机构保安员证书查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradeCertificate> query(GradeCertificateSearchDto dto, AjaxPageResponse<GradeCertificate> ajaxPageResponse);

    /***
     * 保存
     * @param gradeCertificate 等级证信息
     * @return
     */
    void save(GradeCertificate gradeCertificate);
    /***
     * 更新
     * @param gradeCertificate 等级证信息
     * @return
     */
    void update(GradeCertificate gradeCertificate);
    /***
     * 根据ID查询
     * @param id 主键
     * @return
     */
    GradeCertificate findById(Long id);
    /***
     * 根据身份证号查询
     * @param findByIdNum 身份证号
     * @return
     */
    GradeCertificate findByIdNum(String findByIdNum);
    /***
     * 更新等级证人员ID
     * @param gradeCertificate 等级证信息
     */
    void updateByPersonId(GradeCertificate gradeCertificate);

    /**
     * 查询需要生成同步文件的等级证书记录
     * @param dto
     * @return
     */
    List<GradeCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto);


    /***
     * 导入等级证临时表
     * @param subList 列表
     * @param importBatchId 批次号
      */
    void insertTempBatchGradeCertificateImport(@Param("subList")List<Map<String, String>> subList, @Param("importBatchId") Long importBatchId);
    /**
     * 是否有重复身份证数据
     * @param importBatchId 批次号
     */
    void checkIdNumNoRepeat(Long importBatchId);
    /**
     * 验证需要导入的数据身份证是否已存在保安师库
     * @param importBatchId 批次号
     */
    void checkInOtherCom(Long importBatchId);
    /**
     * 检查比对人员是否通过
     * @param importBatchId 批次号
     */
    void checkComparisonPerson(Long importBatchId);
    /**
     * 检查是否在对比人员库
     * @param importBatchId 批次号
     */
    void checkGradePerson(Long importBatchId);
    /**
     * 批量插入等级证数据
     * @param importBatchId 批次号
     */
    void insertGradeCertificateInfo(Long importBatchId);

    /**
     * 查询本次校验失败的导入等级证信息
     * @param importBatchId 批次号
     */
    List<Map<String, String>> getTempImportGradeCertificateList(Long importBatchId);

    /**
     * 删除本次导入的等级证信息
     * @param importBatchId 批次号
     */
    void deleteTempBatchGradeCertificateImport(Long importBatchId);

    /**
     * 查询未推送给SAAS的数据
     * @return
     */
    List<GradeCertificate> findUnPushToSAAS();


    /**
     * 批量更新推送状态
     * @param certificates
     */
    void batchUpdatePushState(@Param("list") List<GradeCertificate> certificates);

    /**
     * 批量更新人员等级证信息
     * @param certificates
     */
    void batchUpdatePersonGradeCertificate(@Param("list") List<GradeCertificate> certificates);

    /**
     * 批量保存
     * @param certificates
     */
    void saveBatch(@Param("list") List<GradeCertificate> certificates);

    GradeCertificate findByPersonGradeId(Long personGradeId);

    GradeCertificate findByIdNumAndGradeLevel(@Param("idnum") String idNum, @Param("appraisalGrade") String appraisalGrade);

    List<String> listIdNumbers(@Param("idNumbers") Set<String> idNumbers);

    void updatePushState(@Param("idNnums")List<String> idNnums, @Param("pushState") boolean pushState);

    List<GradeCertificate> findByIdNums(@Param("idNums")String[] idNumArr);
}
