package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 *保安服务公司快照保存Dao
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
public interface ComCertificateSnapshotDao {

    /****
     * 删除
     * @param comCertificateSnapshot
     * @return
     */
    int delete(ComCertificateSnapshot comCertificateSnapshot);

    /****
     * 保存
     * @param comCertificateSnapshot
     * @return
     */
    int save(ComCertificateSnapshot comCertificateSnapshot);

    /****
     * 新增
     * @param comCertificateSnapshot
     * @return
     */
    int insert(ComCertificateSnapshot comCertificateSnapshot);

    /****
     * 选择性插入
     * @param comCertificateSnapshot
     * @return
     */
    int insertSelective(ComCertificateSnapshot comCertificateSnapshot);

    /****
     * 主键查询
     * @param qrCodeId
     * @return
     */
    ComCertificateSnapshot findByQrCodeId(Long qrCodeId);

    /****
     * 修改
     * @param comCertificateSnapshot
     * @return
     */
    int update(ComCertificateSnapshot comCertificateSnapshot);

    /****
     * 选择修改
     * @param comCertificateSnapshot
     * @return
     */
    int updateSelective(ComCertificateSnapshot comCertificateSnapshot);


    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComCertificateSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComCertificateSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComCertificateSnapshot> findByBatchId(@Param("list")List<ComCertificateSnapshot> list);
}
